<?php

new Shortcodee_Tinymce();
class Shortcodee_Tinymce
{
    public function __construct()
    {
        add_action('admin_init', array($this, 'pu_shortcode_button'));
        add_action('admin_footer', array($this, 'pu_get_shortcodes'));
    }

    /**
     * Create a shortcode button for tinymce
     *
     * @return [type] [description]
     */
    public function pu_shortcode_button()
    {
        if( current_user_can('edit_posts') &&  current_user_can('edit_pages') )
        {
            add_filter( 'mce_external_plugins', array($this, 'pu_add_buttons' ));
            add_filter( 'mce_buttons', array($this, 'pu_register_buttons' ));
        }
    }

    /**
     * Add new Javascript to the plugin scrippt array
     *
     * @param  Array $plugin_array - Array of scripts
     *
     * @return Array
     */
    public function pu_add_buttons( $plugin_array )
    {
        $plugin_array['pushortcodess'] = plugin_dir_url( __FILE__ ) . 'js/shortcode-tinymce-buttonn.js';

        return $plugin_array;
    }

    /**
     * Add new button to tinymce
     *
     * @param  Array $buttons - Array of buttons
     *
     * @return Array
     */
    public function pu_register_buttons( $buttons )
    {
        array_push( $buttons, 'separator', 'pushortcodess' );
        return $buttons;
    }

    /**
     * Add shortcode JS to the page
     *
     * @return HTML
     */
    public function pu_get_shortcodes()
    {
        global $shortcode_tags;
        global $wpdb;

        $result = $wpdb->get_results("SELECT * FROM `wp_lp_popups`");
        echo '<script type="text/javascript">
        var shortcodes_buttonn = new Array();';
        $count = 0;

        foreach($result as $tag => $code)
        {
             $c = json_encode($code);
            echo "shortcodes_buttonn[{$code->id}] = '{$code->popupName}';";
            $count++;
        }
        echo '</script>';
    }
}