<?php

if (! defined('ABSPATH') ) { exit;
}
require_once 'legalPages.php';
global $wpdb;
$lpObj = new legalPages();
$lpObj->lp_enqueue_editor();

$page = isset($_REQUEST['page'])?$_REQUEST['page']:'';

$nonce = isset($_REQUEST['_wpnonce'])? $_REQUEST['_wpnonce']:'';


if((isset($_REQUEST['mode']) && $_REQUEST['mode']=='delete' && current_user_can('manage_options'))) {


    if(! wp_verify_nonce($nonce, 'my-nonce')) {
        wp_die(__('Security Check.'));
    }

    if (! wp_trash_post($_REQUEST['pid']) ) {
        wp_die(__('<span class="label label-danger myAlert">Error in moving to Trash.</span>'));
    }
?>
        <div id="message" >
            <p><span class="label label-success myAlert"><?php _e('Legal page moved to trash.','wplegalpages');?></span></p>
        </div>

<?php
}

?>


<h2 class="hndle title-head"> <?php _e('Available Pages','wplegalpages')?> </h2>
<table class="widefat fixed comments table table-striped">
    <thead>
        <tr>
            <th width="5%"><?php _e('S.No.','wplegalpages');?></th>
                <th width="30%"><?php _e('Page Title','wplegalpages');?></th>
             <th width="10%"><?php _e('Author','wplegalpages');?></th>
             <th width="10%"><?php _e('Date','wplegalpages');?></th>
            <th width="15%"><?php _e('Action','wplegalpages');?></th>


        </tr>
    </thead>

    <tbody>

    <?php
    $postTbl = $wpdb->prefix . "posts";
    $postmetaTbl = $wpdb->prefix . "postmeta";
    $pagesresult = $wpdb->get_results(
        "SELECT $postTbl . *
					FROM $postTbl, $postmetaTbl
					WHERE $postTbl.ID = $postmetaTbl.post_id and $postTbl.post_status='publish'
					AND $postmetaTbl.meta_key =  'is_legal'"
    );

    if($pagesresult ) { ?>

                <?php
                $nonce = wp_create_nonce('my-nonce');
                $count = 1;
                $userTbl = $wpdb->prefix . "users";
                foreach( $pagesresult as $res ) {
                    $url = get_permalink($res ->ID);
                    $author = $wpdb->get_results("SELECT $userTbl.user_login FROM $postTbl, $userTbl WHERE $postTbl.post_author = $userTbl.ID and $postTbl.ID = ".$res ->ID);
                    $delurl =   esc_url(get_bloginfo('url')).'/wp-admin/admin.php?pid='.$res->ID.'&page='.$page.'&mode=delete'.'&_wpnonce='.$nonce;

                ?>

              <tr>
                <td><?php echo $count; ?></td>
                <td><?php echo $res -> post_title; ?></td>
                <td><?php echo ucfirst($author[0]->user_login); ?></td>
                <td><?php echo date("Y/m/d", strtotime($res->post_date)); ?></td>

                <td>
                   <a href="<?php echo get_admin_url(); ?>post.php?post=<?php echo $res ->ID;?>&action=edit"><?php _e('Edit','wplegalpages');?></a> | <a href="<?php echo $url; ?>"><?php _e('View','wplegalpages');?></a>| <a href="<?php echo $delurl;?>"><?php _e('Trash','wplegalpages');?></a>                </td>
            </tr>

            <?php
                $count++;
                }
                ?>

    <?php } else { ?>
        <tr>
            <td colspan="3"><?php _e('No page yet','wplegalpages');?></td>
        </tr>
    <?php } ?>
    </tbody>

    <tfoot>
        <tr>

           <th width="5%"><?php _e('S.No.','wplegalpages');?></th>
                <th width="30%"><?php _e('Page Title','wplegalpages');?></th>
             <th width="10%"><?php _e('Author','wplegalpages');?></th>
             <th width="10%"><?php _e('Date','wplegalpages');?></th>
            <th width="15%"><?php _e('Action','wplegalpages');?></th>


        </tr>
    </tfoot>

 </table>
