(function() {
    tinymce.create('tinymce.plugins.pushortcodess', {

        init : function(ed, url) {
            var t = this;
            t.editor = ed;
        },

       
        createControl : function(n, cm)
        {
            if(n=='pushortcodess') {
                var button = cm.createListBox('shortcode_dropdownn',
                {
                     title : 'popup Shortcodes', 
                     onselect : function(code) {
                        if(tinyMCE.activeEditor.selection.getContent() == '') {
                            tinyMCE.activeEditor.selection.setContent( '['+code+']' );
                        } else {
                            tinyMCE.activeEditor.execCommand('mceReplaceContent', false, '['+code+']{$selection}[/'+code+']');
                        }
                        return false;
                     }
                });

                
                for(var count=0; count<shortcodes_buttonn.length; count++) {
                    button.add('['+shortcodes_buttonn[count]+']', shortcodes_buttonn[count]);
                }
                return button;
            }
            return null;
        }
    });

    tinymce.PluginManager.add('pushortcodess', tinymce.plugins.pushortcodess);

})();

(function() {

    tinymce.PluginManager.add('pushortcodess', function( editor )
    {
        var shortcodeValues = [];
        jQuery.each(shortcodes_buttonn, function(i)
        {   
            if (shortcodes_buttonn[i] != undefined) {
               shortcodeValues.push({text: shortcodes_buttonn[i], value:i});
            }
        });

        editor.addButton('pushortcodess', {
            type: 'listbox',
            text: 'popup Shortcodes',
            onselect: function(e) {
                var v = e.control.settings.text;
                var value = e.control.settings.value;
                tinyMCE.activeEditor.selection.setContent( '[wp-legalpopup pid=' + value + ']' );
            },
            values: shortcodeValues
        });
    });
})();