(function() {
    tinymce.create('tinymce.plugins.pushortcodes', {

        init : function(ed, url) {
            var t = this;
            t.editor = ed;
        },

       
        createControl : function(n, cm)
        {
            if(n=='pushortcodes') {
                var button = cm.createListBox('shortcode_dropdown',
                {
                     title : 'Shortcodes',
                     onselect : function(code) {
                        if(tinyMCE.activeEditor.selection.getContent() == '') {
                            tinyMCE.activeEditor.selection.setContent( '['+code+']' );
                        } else {
                            tinyMCE.activeEditor.execCommand('mceReplaceContent', false, '['+code+']{$selection}[/'+code+']');
                        }
                        return false;
                     }
                });

                
                for(var count=0; count<shortcodes_button.length; count++) {
                    button.add('['+shortcodes_button[count]+']', shortcodes_button[count]);
                }
                return button;
            }
            return null;
        }
    });

    tinymce.PluginManager.add('pushortcodes', tinymce.plugins.pushortcodes);

})();

(function() {

    tinymce.PluginManager.add('pushortcodes', function( editor )
    {
        var shortcodeValues = [];
        jQuery.each(shortcodes_button, function(i)
        {   
            if (shortcodes_button[i] != undefined) {
               shortcodeValues.push({text: shortcodes_button[i], value:i});
            }
        });

        editor.addButton('pushortcodes', {
            type: 'listbox',
            text: 'Legal Eagle Templates',
            onselect: function(e) {
                var v = e.control.settings.text;
                var value = e.control.settings.value;
                tinyMCE.activeEditor.selection.setContent( '[wp-legalpage tid=' + value + ']' );
            },
            values: shortcodeValues
        });
    });
})();