<?php
if ( ! class_exists( 'wp_auto_update_legal_pages' ) ){

class wp_auto_update_legal_pages
{
   
    //The plugin current version
    public $current_version;
 
    // The plugin remote update path
    public $update_path;
 
    // Product ID
    public $product_id;
    
    // Plugin Slug (plugin_directory/plugin_file.php)
    public $plugin_slug;
 
    // Plugin name (plugin_file)
    public $slug;
 
    // Initialize a new instance of the WordPress Auto-Update class
    function __construct( $current_version , $update_path, $plugin_slug , $product_id )
    {
        // Set the class public variables
        $this->current_version = $current_version;
        $this->update_path = $update_path;
        $this->product_id = $product_id;
        $this->plugin_slug = $plugin_slug;
        list ( $t1 , $t2 ) = explode('/', $plugin_slug);
        $this->slug = str_replace( '.php' , '' , $t2 );
 
        //to check updates
        add_filter( 'pre_set_site_transient_update_plugins' , array( &$this , 'check_update' ) );
 
        //for information
        add_filter( 'plugins_api' , array( &$this , 'check_info' ), 10 , 3 );
    }
 
    // Add our self-hosted autoupdate plugin to the filter transient
     
    public function check_update($transient)
    {
        if( empty ( $transient->checked ) ) {
            return $transient;
        }

        // Get the remote version
        $version_details = $this->getRemote_version();
        
        $remote_version  = $version_details->new_version;
	
	// If a newer version is available, add the update
        if( version_compare( $this->current_version , $remote_version , '<' ) ) {
            $obj = new stdClass();
            $obj->slug = $this->slug;
            $obj->new_version = $remote_version;
            $obj->url = $this->update_path;
	    $key = get_option( 'wpeka_api_key' );
            if( !empty( $key ) && !empty( $version_details->package ) )
                $obj->package = $version_details->package;
            $transient->response[$this->plugin_slug] = $obj;
        }
        
        return $transient;
    }

    // Add our self-hosted description to the filter
     
    public function check_info( $false , $action , $arg )
    {
        if( !isset( $arg->slug ) || $arg->slug != $this->slug ) return $false;

        $information = $this->getRemote_information();
	
        $information->author = "<a href='https://club.wpeka.com/'>WPEka Team</a>";
          
        return $information;
    }
    
    // Returns the remote version
    
    public function getRemote_version()
    {
        $key = get_option( 'wpeka_api_key' );
        $client_credentials = get_option( 'wpeka_client_credentials' );
	
	if( empty( $key ) )
		$key = '';
        else
            $key = $key['secret_key'];
	        
        if( empty( $client_credentials ) )
		$user_email = '';
        else
            $user_email = $client_credentials['wpeka_client_email'];
	
	$args = array(
		'request' => 'version',
		'slug' => $this->slug,
		'key' => $key,
                'wpeka_client_email' => $user_email,
                'product_id' => $this->product_id,
		'url' => esc_url( home_url( '/' ) )
	);
				
	$response = wp_remote_post( $this->update_path , array(
		'timeout' => 45,
		'redirection' => 5,
		'httpversion' => '1.0',
		'headers' => array( 'user-agent' => 'wpekaautoupdater/'),
		'body' => $args,
		'sslverify' => false
	) );
        
	$response = wp_remote_retrieve_body( $response );
	
	if( !is_wp_error( $response ) ){	
		$result = json_decode( $response );
		
		return $result;
	}
        return false;
    }
 
    // Get information about the remote version
    
    public function getRemote_information()
    {
        $key = get_option( 'wpeka_api_key' );
        $client_credentials = get_option( 'wpeka_client_credentials' );
	
	if( empty( $key ) )
		$key = '';
        else
            $key = $key['secret_key'];
	        
        if( empty( $client_credentials ) )
		$user_email = '';
        else
            $user_email = $client_credentials['wpeka_client_email'];
	
        $args = array(
		'request' => 'info',
		'slug' => $this->slug,
		'key' => $key,
                'wpeka_client_email' => $user_email,
                'product_id' => $this->product_id,
		'url' => esc_url( home_url( '/' ) )
	);
				
	$response = wp_remote_post( $this->update_path , array(
		'timeout' => 45,
		'redirection' => 5,
		'httpversion' => '1.0',
		'headers' => array( 'user-agent' => 'wpekaautoupdater/' . $this->current_version ),
		'body' => $args,
		'sslverify' => false
	) );

	$response = wp_remote_retrieve_body( $response );
	
	if( !is_wp_error( $response ) ){	
		$result = json_decode($response);
		
		return unserialize($result);
	}
        return false;
    }
 
}
}
?>
