<?php

if ( ! defined( 'ABSPATH' ) ) exit;
require_once( 'legalPages.php' );
global $wpdb;
$lpObj = new legalPages();
$lpObj->lp_enqueue_editor();



if(!empty($_POST) && isset($_POST['lp-submit'])) {
  if(isset($_POST['lp_age_verification'])){
      update_option('lp_age_verification', addslashes(sanitize_text_field($_POST['lp_age_verification'])));
  }
  if(isset($_POST['_lp_always_verify'])){
    update_option('_lp_always_verify', htmlentities(sanitize_text_field($_POST['_lp_always_verify'])));
  }
  if(isset($_POST['_lp_minimum_age'])){
    update_option('_lp_minimum_age', sanitize_text_field($_POST['_lp_minimum_age']));
  }
  if(isset($_POST['_lp_heading'])){
    update_option('_lp_heading', sanitize_text_field($_POST['_lp_heading']));
  }
  if(isset($_POST['_lp_description'])){
    update_option('_lp_description', sanitize_text_field($_POST['_lp_description']));
  }
  if(isset($_POST['_lp_require_for'])){
    update_option('_lp_require_for', sanitize_text_field($_POST['_lp_require_for']));
  }

}

$lp_age_verification    = get_option('lp_age_verification');
$_lp_always_verify		= get_option('_lp_always_verify');
$_lp_minimum_age        = get_option('_lp_minimum_age');
$_lp_heading			= get_option('_lp_heading');
$_lp_description		= get_option('_lp_description');
$_lp_require_for        = get_option('_lp_require_for');

?>
<h2 class="title-head">  <?php _e('Age verification','wplegalpages');?> : </h2>
<div style="clear:both;"></div>
<div class="wrap">
    <div class="postbox all_pad">
<div><b> Note :</b> If you enable the age verification setting then it will remove the basic 'Adult Content Site' popup and will show this customised popup.</div>
        <form id="lp_age_verify_form" enctype="multipart/form-data" method="post" action="" name="terms">
            <table class="form-table">

                <tr>
                    <th>
                        <span><?php _e( 'Enable age verification', 'wplegalpages' ); ?></span>
                    </th>

                    <td>
                        <fieldset>
                            <label>
                                <input type="radio" name="_lp_require_for" value="site" <?php checked( 'site', get_option( '_lp_require_for', 'site' ) ); ?>/>
                                <?php esc_html_e( 'Yes', 'wplegalpages' ); ?> <br />
                            </label>
                            <br />
                            <label>
                                <input type="radio" name="_lp_require_for" value="content" <?php checked( 'content', get_option( '_lp_require_for', 'content' ) ); ?>/>
                                <?php esc_html_e( 'No', 'wplegalpages' ); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>




                <tr>
                  <th>
                      <span><?php _e( 'Verify the age of :', 'wplegalpages' ); ?></span>
                  </th>

                    <td>
                <fieldset>


                    <label>
                        <input type="radio" name="_lp_always_verify" value="guests" <?php checked( 'guests', get_option( '_lp_always_verify', 'guests' ) ); ?>/>
                        <?php esc_html_e( 'Guests only', 'wplegalpages' ); ?><br>
                        <span class="description"><?php _e('Logged-in users will not need to verify their age.'); ?></span>
                        <br />
                    </label>
                    <br />
                    <label>
                        <input type="radio" name="_lp_always_verify" value="all" <?php checked( 'all', get_option( '_lp_always_verify', 'guests' ) ); ?>/>
                        <?php esc_html_e( 'All visitors', 'wplegalpages' ); ?>
                    </label>
                </fieldset>
                    </td>
                </tr>

                <tr>

                <th>
                    <span><?php _e( 'Visitors must be', 'wplegalpages' ); ?></span>
                </th>
                <td>
                    <input name="_lp_minimum_age" type="number" id="_lp_minimum_age" step="1" min="10" class="small-text" value="<?php echo esc_attr( get_option( '_lp_minimum_age', '21' ) ); ?>" /> <?php esc_html_e( 'years old or older to view this site', 'wplegalpages' ); ?>
                </td>

                </tr>

                <table class="form-table">
                    <h2 class="title-head">  <?php _e('Display Options','wplegalpages');?> : </h2>
                <tbody>
                <tr>
                    <th>
                         <span><?php _e( 'Heading', 'wplegalpages' ); ?></span>
                    </th>

                    <td>
                        <input name="_lp_heading" type="text" id="_lp_heading" value="<?php echo esc_attr( get_option( '_lp_heading', __( 'You must be atleast {age} years of age to visit this site.', 'wplegalpages' ) ) ); ?>" class="regular-text" />
                        <br>
                        <span class="description"><?php _e( 'Here {age} is used as the minimum age you provide for any user.');?></span>
                    </td>
                </tr>
                    <br>
                <tr>
                    <th>
                        <span><?php _e( 'Description', 'wplegalpages' ); ?></span>
                    </th>

                    <td>
                        <input name="_lp_description" type="text" id="_lp_description" value="<?php echo esc_attr( get_option( '_lp_description', __( 'Please verify your age', 'wplegalpages' ) ) ); ?>" class="regular-text" />
                    </td>
                     <br>
                </tr>
                </tbody>
                </table>


            </table>
            <p class="top_pad">
                <input type="submit" class="btn btn-primary" name="lp-submit" value="<?php _e('Update','wplegalpages') ?>" />
            </p>

        </form>
    </div>
</div>
