<?php

class FTCWidget extends WP_Widget {

    function __construct() {
        parent::__construct(
            'FTCWidget',
            'FTC Disclaimer',
            array( 'description' => 'FTC Disclaimer', ) // Args
        );
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }
        echo ($instance['content']);
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = 'FTC Disclaimer';
        $content = "Disclosure: Some of the links in this post are 'affiliate links.' This means if you click on the link and purchase the item, I will receive an affiliate commission.";

        if(!empty( $instance['title'] )){
            $title = $instance['title'];
            $content = $instance['content'];
        }
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">Title:</label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   type="text"
                   value="<?php echo esc_attr( $title ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">Content:</label>
            <textarea name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"
                      class="widefat"
                      style="min-height:300px"
                      id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php echo esc_html( $content ); ?></textarea>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['content'] = ( ! empty( $new_instance['content'] ) ) ? strip_tags( $new_instance['content'] ) : '';

        return $instance;
    }

    public static function register(){
        register_widget( 'FTCWidget' );
    }
}
  add_action( 'widgets_init', array('FTCWidget', 'register') );
