<?php
require('../../../wp-blog-header.php');

if (!class_exists('OAuth2/Client')) {
    require_once __DIR__ . '/oauth2/Client.php';
    require_once __DIR__ . "/oauth2/GrantType/IGrantType.php";
    require_once __DIR__ . "/oauth2/GrantType/AuthorizationCode.php";
    require_once __DIR__ . "/oauth2/GrantType/RefreshToken.php";
}


$campaign = $_GET['campaign'];

if (empty($campaign)) {
    echo 'Invalid URL'; die;
}

if (isset($_GET["error"])) {
    echo("<pre>OAuth Error: " . $_GET["error"]."\n");
    echo('<a href="index.php">Retry</a></pre>');
    die;
}

$authorizeUrl = 'https://ssl.reddit.com/api/v1/authorize';
$accessTokenUrl = 'https://ssl.reddit.com/api/v1/access_token';
$clientId = get_post_meta(111111113, $campaign . 'smRdID', TRUE);
$clientSecret = get_post_meta(111111113, $campaign . 'smRdSecret', TRUE);
$userAgent = 'SocialTrafficBot by DanGreen';

$redirectUrl = plugin_dir_url(__FILE__ ) . "reddit-oauth.php?campaign=$campaign";

$client = new OAuth2\Client($clientId, $clientSecret, OAuth2\Client::AUTH_TYPE_AUTHORIZATION_BASIC);
$client->setCurlOption(CURLOPT_USERAGENT,$userAgent);

if (!isset($_GET["code"]))
{
    $authUrl = $client->getAuthenticationUrl($authorizeUrl, $redirectUrl, array("scope" => "identity, edit, flair, history, modconfig, modflair, modlog, modposts, modwiki, mysubreddits, privatemessages, read, report, save, submit, subscribe, vote, wikiedit, wikiread", "state" => "SomeUnguessableValue", "duration"=>"permanent"));
    header("Location: ".$authUrl);
    die("Redirect");
}
else {
    $params = array("code" => $_GET["code"], "redirect_uri" => $redirectUrl);
    $response = $client->getAccessToken($accessTokenUrl, "authorization_code", $params);
    $accessTokenResult = $response["result"];

    update_post_meta(111111113, $campaign . 'smRdCode', $_GET["code"]);
    update_post_meta(111111113, $campaign . 'smRdAccessToken', $accessTokenResult["access_token"]);
    update_post_meta(111111113, $campaign . 'smRdRefreshToken', $accessTokenResult["refresh_token"]);

    echo '
    <script type="text/javascript">
        window.close();
    </script>';
}
