<?php
function smPostToBlog($img, $content, $title, $link, $campaign, $ioId) {
	// $content = smRemoveImage($content);

	$showsource = get_post_meta(111111113, $campaign . 'smshowsource', TRUE);
	$sourcelabel = get_post_meta(111111113, $campaign . 'smsourcelabel', TRUE);
	$category = get_post_meta(111111113, $campaign . 'smcategory', TRUE);
	$smpostlength = get_post_meta(111111113, $campaign . 'smpostlength', TRUE);

	$smFirstAsFeatured = get_post_meta(111111113, $campaign . 'sm-first-as-featured', 'yes');
	$smStripFirstImage = get_post_meta(111111113, $campaign . 'sm-strip-first-image', 'yes');
	$smStripLinks = get_post_meta(111111113, $campaign . 'sm-strip-links', true);

	if (empty($category)) {
		$category = "Uncategorized";
	}

	$catid = get_cat_ID($category);

	if (!empty($smpostlength)) {
		$content = strip_tags($content, '<br><p><img><iframe><video><source>');
		$content = substr($content, 0, $smpostlength);
		$content = $content . "... <a href ='" . $link . "'>Read More</a>";
	}

	if ($smStripLinks === 'yes') {
		$content = strip_tags($content, '<a><br><p><img><iframe><video><source>');
	}

	if ($smStripFirstImage === 'yes') {
		$content = smRemoveImage($content);
	}

	if (empty($ioId) || $ioId === 0) {
		$smintro = get_post_meta(111111113, $campaign . 'smintro', TRUE);
		$smoutro = get_post_meta(111111113, $campaign . 'smoutro', TRUE);
	} else {
		$vals = getIntroOutroById($ioId);
		if (!empty($vals)) {
			$smintro = $vals[0];
			$smoutro = $vals[1];
		} else {
			$smintro = get_post_meta(111111113, $campaign . 'smintro', TRUE);
			$smoutro = get_post_meta(111111113, $campaign . 'smoutro', TRUE);
		}
	}

	$spintax = new smSpintax();
	$smintro = $spintax->process($smintro);
	$smoutro = $spintax->process($smoutro);

	$content = "<p>" . $smintro . "</p><p>" . $content;
	$content = $content . "</p><p>" . $smoutro;

	if ($showsource == "yes") {
		$content = $sourcelabel . " <a href ='" . $link . "'>" . $link . "</a> " . $content . "<br />";
	}

	$smdraft = get_post_meta(111111113, $campaign . 'smdraft', TRUE);
	if ($smdraft == "yes") {
		$status = "draft";
	} else {
		$status = "publish";
	}

	// Create post object
	$my_post = array(
		'post_title' => $title,
		'post_content' => $content,
		'post_excerpt' => $content,
		'post_status' => $status,
		'post_author' => 1,
		'post_category' => array($catid),
	);

	global $allowedposttags;
	$allowedposttags['div'] = array('align' => array(), 'class' => array(), 'id' => array(), 'dir' => array(), 'lang' => array(), 'style' => array(), 'xml:lang' => array());
	$allowedposttags['iframe'] = array('src' => array());

	$post_id = wp_insert_post($my_post, $wp_error);

	if ($smFirstAsFeatured === 'yes' && $img !== '') {
		smUploadImage($post_id, $img);
	}

	return $post_id;
}

function smUploadImage($post_id, $url) {
	require_once ABSPATH . "wp-admin" . '/includes/image.php';
	require_once ABSPATH . "wp-admin" . '/includes/file.php';
	require_once ABSPATH . "wp-admin" . '/includes/media.php';

	$tmp_name = download_url($url);

	$file_array['name'] = $post_id . '-thumb.jpg'; // new filename based on slug
	$file_array['tmp_name'] = $tmp_name;

	// If error storing temporarily, unlink
	if (is_wp_error($tmp_name)) {
		@unlink($file_array['tmp_name']);
		$file_array['tmp_name'] = '';
	}

	// do validation and storage .  Make a description based on the Post_ID
	$attachment_id = media_handle_sideload($file_array, $post_id, 'Thumbnail for ' . $post_id);

	// If error storing permanently, unlink
	if (is_wp_error($attachment_id)) {
		$error_string = $attachment_id->get_error_message();
		@unlink($file_array['tmp_name']);
		return;
	}

	// Set as the post attachment
	$post_result = add_post_meta($post_id, '_thumbnail_id', $attachment_id, true);
	$src = wp_get_attachment_url($attachment_id);

	return $src;
// echo $post_result);
}

// strip first image
function smRemoveImage($content) {
	$content = preg_replace('/<img[^>]+src=[\'"](?P<src>.+?)[\'"][^>]*>/i', '', $content);
	return $content;
}

function getIntroOutroById($id) {
	global $wpdb;
	$wpdb->show_errors();
	$table_name = $wpdb->prefix . "smintrosoutros";

	$query = "SELECT * FROM $table_name where id=$id ORDER BY setname ASC";
	$results = $wpdb->get_row($query);

	if (empty($results)) return null;
	return [$results->intro, $results->outro];
}
?>
