<?php
require '../../../wp-blog-header.php';

set_time_limit(200);
function return_300($seconds) {
	// change the default feed cache recreation period to 2 hours
	return 300;
}

add_filter('wp_feed_cache_transient_lifetime', 'return_300');

$campaign = smSelectCampaign();
if (empty($campaign)) {
	echo "no campaign selected <br/>\n";
	exit;
}

switch (rand(1, 100) % 3 === 0) {
case 0:
	$post = smChooseWPPost($campaign);
	if (empty($post)) {
		echo "nothing to post <br/>\n";
		exit;
	}

	$res = doPostToFacebook($campaign, $post);
	break;
case 1:
	smRun($campaign);
	echo "Reply/Commenting Facebook Finished <br/>\n";
	break;
case 2:
	doCustomToFacebook($campaign);
	echo "Custom To Facebook <br/>\n";
	break;
}

echo "Cron Finished <br/>\n";

function doPostToFacebook($campaignId, $wpPostId) {
	$permalink = get_permalink(intval($wpPostId));
	$post = get_post(intval($wpPostId));

	if (empty($post)) {
		echo "No Post found with given ID<br/>\n";
		return;
	}

	if (sm_check_in_master_log('WP Post To Facebook', $campaignId, $wpPostId) == 0) {
		$imgURL = get_the_post_thumbnail_url($post->ID, 'full');
		smPostToFacebook($permalink, $post->post_title, $imgURL, $campaignId, $wpPostId);
	} else {
		echo "Post already posted to facebook<br/>\n";
	}

	return;
}

function doCustomToFacebook($campaignId) {
	$custom = smGetCustom($campaignId);

	if (empty($custom)) {
		echo "No custom post found<br/>\n";
		return;
	}

	if (sm_check_in_master_log('Custom to Facebook', $campaignId, $custom->id) == 0) {
		smPostToFacebook($custom->url, $custom->headline, $custom->image, $campaignId, $custom->id, 'Custom to Facebook');
		return true;
	} else {
		echo "Custom {$custom->id} already posted to facebook<br/>\n";
		return false;
	}
}

function smPostToFacebook($link, $title, $imgURL, $campaign, $wpPostId) {
	$title = html_entity_decode($title);
	$id = get_post_meta(111111113, $campaign . 'smFbID', true);
	$secret = get_post_meta(111111113, $campaign . 'smFbSecret', true);
	$fbpageid = get_post_meta(111111113, $campaign . 'smpageid', true);

	require_once "./nxs-api/nxs-api.php";
	require_once "./nxs-api/nxs-http.php";
	require_once "./inc/nxs-functions.php";

	$session = array('cn' => $id, 'xs' => $secret);

	$message = array(
		'pText' => $title,
		'imageURL' => $imgURL,
		'url' => $link,
		'postType' => 'A'
	);

	$nt = new nxsAPI_FB();
	$nt->sid = $session;
	$result = $nt->post($fbpageid, $message);

	if (!empty($result) && is_array($result) && !empty($result['post_url'])) {
		echo "Error while trying to post to facebook <br/>\n";
		var_dump($result);
	} else {
		echo "Successfully Posted to Facebook<br/>";
		var_dump($result);
		sm_add_to_master_log('WP Post To Facebook', $campaign, $wpPostId, $result['post_url'], $link);
	}
}

class smSpintax {
	public function process($text) {
		return preg_replace_callback(
			'/\{(((?>[^\{\}]+)|(?R))*)\}/x',
			array($this, 'replace'),
			$text
		);
	}

	public function replace($text) {
		$text = $this->process($text[1]);
		$parts = explode('|', $text);
		return $parts[array_rand($parts)];
	}
}
